﻿# coding: UTF-8

from gpib import Gpib

#Timeout(1sec)
Timeout_default_s = 1
Timeout_default_ms = 1000

def main():
    #Instantiation of the GPIB communication class
    gpib = Gpib()

    #Connect
    print("BoardID?")
    boardID = input()
    print("PrimaryAddress?")
    primaryAddress = input()
    if not gpib.open(boardID, primaryAddress, Timeout_default_ms):
        return
    
    #Send and receive commands
    while True:
        print("Please enter the command (Exit with no input)")
        command = input()
        #Exit if no input
        if command == "":
            break
        #If the command contains "?"
        if "?" in command :
            msgBuf = gpib.SendQueryMsg(command, Timeout_default_s)
            print(msgBuf) 
        #Send only
        else:
            gpib.sendMsg(command)
        
    gpib.close()

if __name__ == '__main__':
  main()
